const { createProxyMiddleware } = require('http-proxy-middleware');

const rewriteLocationHeader = (proxyRes, req, res) => {
  if ([301, 302].includes(proxyRes.statusCode) && proxyRes.headers.location) {
    // Regular expression to match 'aramco.woodburn.digital' with or without ':443'
    const targetRegex = /https:\/\/dx\.sbx0069\.play\.hclsofy\.com(:443)?/;
    
    const newLocation = proxyRes.headers.location.replace(targetRegex, 'http://localhost:4200');
    proxyRes.headers.location = newLocation;
  }
};

module.exports = {
  '/wps': {
    target: 'https://dx.sbx0069.play.hclsofy.com',
    secure: false,
    changeOrigin: true,
    cookieDomainRewrite: 'auto',
    onProxyRes: rewriteLocationHeader
  },
  '/dx': {
    target: 'https://dx.sbx0069.play.hclsofy.com',
    secure: false,
    changeOrigin: true,
    cookieDomainRewrite: 'auto',
    onProxyRes: rewriteLocationHeader
  },
  '/apps': {
    target: 'https://dx.sbx0069.play.hclsofy.com',
    secure: false,
    changeOrigin: true,
    cookieDomainRewrite: 'auto',
    onProxyRes: rewriteLocationHeader
  }
};